<?php
/* --------------------------------------------------------------
 CacheCleanerOverview.php 2020-08-27
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\CacheCleaner\App\Actions;

use Gambio\Admin\Application\Http\AdminModuleAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * Class CacheCleanerOverview
 *
 * @package GXModules\GambioSamples\CacheCleaner\App\Actions
 */
class CacheCleanerOverview extends AdminModuleAction
{
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $pageTitle    = 'Cache Cleaner';
        $templatePath = __DIR__ . '/../../ui/template/overview.html';
        
        $data     = [
            'overviewJs' => "{$this->url->base()}/GXModules/GambioSamples/CacheCleaner/ui/assets/overview.js"
        ];
        $template = $this->render($pageTitle, $templatePath, $data);
        
        return $response->write($template);
    }
}