<?php
/* --------------------------------------------------------------
 HelloWorldAction.php 2020-08-28
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\HelloWorld;

use Gambio\Admin\Application\Http\AdminModuleAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * Class HelloWorldAction
 *
 * In general, action classes are responsible to handle incoming request.
 * Routes are defined in the module class (*Module.php extending Gambio\Core\Application\Modules\AbstractModule).
 *
 * Actions should extend from Gambio\Admin\Application\Http\AdminModuleAction to include functionality that is suited
 * to the Gambio Admin at all.
 *
 * Finally, they return any PSR-7 compatible response instance.
 * (Technically by ::__invoke(), but ::handle() abstract it away. Take a look into the parent class for details.)
 *
 * @package GXModules\GambioSamples\HelloWorld
 */
class HelloWorldAction extends AdminModuleAction
{
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $template = $this->render('Hello World', __DIR__ . '/template.html', ['value' => __CLASS__]);
        
        return $response->write($template);
    }
}