<?php
/* --------------------------------------------------------------
 ShopStatusOverview.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Actions;

use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;
use GXModules\GambioSamples\ShopStatusManager\Services\OfflineStatusService;
use GXModules\GambioSamples\ShopStatusManager\Services\PopupService;
use GXModules\GambioSamples\ShopStatusManager\Services\TopbarService;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAction;

/**
 * Class ShopStatusOverview
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Actions
 */
class ShopStatusOverview extends TwigAction
{
    /**
     * @var TopbarService
     */
    private $topbarService;
    
    /**
     * @var PopupService
     */
    private $popupService;
    
    /**
     * @var OfflineStatusService
     */
    private $statusService;
    
    
    /**
     * @param TopbarService        $topbarService
     * @param PopupService         $popupService
     * @param OfflineStatusService $statusService
     */
    public function __construct(
        TopbarService $topbarService,
        PopupService $popupService,
        OfflineStatusService $statusService
    ) {
        $this->topbarService = $topbarService;
        $this->popupService  = $popupService;
        $this->statusService = $statusService;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $topbar = $this->topbarService->getTopBar();
        $popup  = $this->popupService->getPopup();
        $status = $this->statusService->getOfflineStatus();
        
        $template = $this->render('Shop Status',
                                  'shop_status/overview.twig',
                                  [
                                      'topbar' => $topbar->toArray(),
                                      'popup'  => $popup->toArray(),
                                      'status' => $status->toArray(),
                                  ]);
        
        return $response->write($template);
    }
}