<?php
/* --------------------------------------------------------------
 ShopStatusMapper.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Data;

use GXModules\GambioSamples\ShopStatusManager\Model\Popup;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContents;
use GXModules\GambioSamples\ShopStatusManager\Model\OfflineStatus;
use GXModules\GambioSamples\ShopStatusManager\Model\Topbar;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusFactory;

/**
 * Class ShopStatusMapper
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Data
 */
class ShopStatusMapper
{
    /**
     * @var ShopStatusFactory
     */
    private $factory;
    
    
    /**
     * @param ShopStatusFactory $factory
     */
    public function __construct(ShopStatusFactory $factory)
    {
        $this->factory = $factory;
    }
    
    
    /**
     * @param array $data
     *
     * @return Topbar
     */
    public function mapTopbar(array $data): Topbar
    {
        $status   = $data['status'];
        $color    = $data['color'];
        $contents = $this->mapContents($data);
        
        return $this->factory->createTopbar($status, $color, $contents);
    }
    
    
    /**
     * @param array $data
     *
     * @return Popup
     */
    public function mapPopup(array $data): Popup
    {
        $status   = $data['status'];
        $contents = $this->mapContents($data);
        
        return $this->factory->createPopup($status, $contents);
    }
    
    
    /**
     * @param array $data
     *
     * @return OfflineStatus
     */
    public function mapStatus(array $data): OfflineStatus
    {
        return $this->factory->createShopStatus($data['status'], $data['message']);
    }
    
    
    /**
     * @param array $data
     *
     * @return PopupContents
     */
    private function mapContents(array $data): PopupContents
    {
        $contentData = [];
        foreach ($data['contents'] as $content) {
            $contentData[] = $this->factory->createPopupContent($content['content'], $content['code']);
        }
        
        return $this->factory->createPopupContents(...$contentData);
    }
}