<?php
/* --------------------------------------------------------------
 PopupService.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\Popup;
use GXModules\GambioSamples\ShopStatusManager\Services\PopupService as Service;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusFactory;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusRepository;

/**
 * Class PopupService
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Services
 */
class PopupService implements Service
{
    /**
     * @var ShopStatusRepository
     */
    private $repository;
    
    /**
     * @var ShopStatusFactory
     */
    private $factory;
    
    
    /**
     * @param ShopStatusRepository $repository
     * @param ShopStatusFactory    $factory
     */
    public function __construct(ShopStatusRepository $repository, ShopStatusFactory $factory)
    {
        $this->repository = $repository;
        $this->factory    = $factory;
    }
    
    
    /**
     * @return Popup
     */
    public function getPopup(): Popup
    {
        return $this->repository->getPopup();
    }
    
    
    public function enablePopup(): void
    {
        $popup = $this->repository->getPopup();
        $popup->enable();
        
        $this->repository->savePopup($popup);
    }
    
    
    public function disablePopup(): void
    {
        $popup = $this->repository->getPopup();
        $popup->disable();
        
        $this->repository->savePopup($popup);
    }
    
    
    /**
     * @param string $newContent
     * @param string $languageCode
     */
    public function changePopupContent(string $newContent, string $languageCode): void
    {
        $content = $this->factory->createPopupContent($newContent, $languageCode);
        $popup   = $this->repository->getPopup();
        $popup->changeContent($content);
        
        $this->repository->savePopup($popup);
    }
}