<?php
/* --------------------------------------------------------------
 TopbarService.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\Topbar;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusFactory;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusRepository;
use GXModules\GambioSamples\ShopStatusManager\Services\TopbarService as Service;

/**
 * Class TopbarService
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Services
 */
class TopbarService implements Service
{
    /**
     * @var ShopStatusRepository
     */
    private $repository;
    
    /**
     * @var ShopStatusFactory
     */
    private $factory;
    
    
    /**
     * @param ShopStatusRepository $repository
     * @param ShopStatusFactory    $factory
     */
    public function __construct(ShopStatusRepository $repository, ShopStatusFactory $factory)
    {
        $this->repository = $repository;
        $this->factory    = $factory;
    }
    
    
    /**
     * @return Topbar
     */
    public function getTopBar(): Topbar
    {
        return $this->repository->getTopbar();
    }
    
    
    public function enableTopBar(): void
    {
        $topBar = $this->repository->getTopbar();
        $topBar->enable();
        
        $this->repository->saveTopbar($topBar);
    }
    
    
    public function disableTopBar(): void
    {
        $topBar = $this->repository->getTopbar();
        $topBar->disable();
        
        $this->repository->saveTopbar($topBar);
    }
    
    
    /**
     * @param string $hexColorCode
     */
    public function changeTopBarColor(string $hexColorCode): void
    {
        $topBar = $this->repository->getTopbar();
        $topBar->changeColor($hexColorCode);
        
        $this->repository->saveTopbar($topBar);
    }
    
    
    /**
     * @param string $newContent
     * @param string $languageCode
     */
    public function changeTopBarContent(string $newContent, string $languageCode): void
    {
        $content = $this->factory->createPopupContent($newContent, $languageCode);
        $topBar  = $this->repository->getTopbar();
        $topBar->changeContent($content);
        
        $this->repository->saveTopbar($topBar);
    }
}