<?php
/* --------------------------------------------------------------
 ShopStatus.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects;

use GXModules\GambioSamples\ShopStatusManager\Model\OfflineStatus as Status;

/**
 * Class OfflineStatus
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects
 */
class OfflineStatus implements Status
{
    /**
     * @var bool
     */
    private $offlineMode;
    
    /**
     * @var string
     */
    private $message;
    
    
    /**
     * @param bool   $status
     * @param string $message
     */
    public function __construct(bool $status, string $message)
    {
        $this->offlineMode = $status;
        $this->message     = $message;
    }
    
    
    public function enableOfflineMode(): void
    {
        $this->offlineMode = true;
    }
    
    
    public function disableOfflineMode(): void
    {
        $this->offlineMode = false;
    }
    
    
    /**
     * @param string $newMessage
     */
    public function changeMessage(string $newMessage): void
    {
        $this->message = $newMessage;
    }
    
    
    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            'isOffline' => $this->offlineMode,
            'message'   => $this->message
        ];
    }
}