<?php
/* --------------------------------------------------------------
 TopBar.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects;

use GXModules\GambioSamples\ShopStatusManager\Model\PopupContent;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContents;
use GXModules\GambioSamples\ShopStatusManager\Model\Topbar as TopbarApi;

/**
 * Class TopBar
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects
 */
class TopBar implements TopbarApi
{
    /**
     * @var bool
     */
    private $status;
    
    /**
     * @var string
     */
    private $hexColorCode;
    
    /**
     * @var PopupContents
     */
    private $contents;
    
    
    /**
     * @param bool          $status
     * @param string        $hexColorCode
     * @param PopupContents $contents
     */
    public function __construct(bool $status, string $hexColorCode, PopupContents $contents)
    {
        $this->status       = $status;
        $this->hexColorCode = $hexColorCode;
        $this->contents     = $contents;
    }
    
    
    public function enable(): void
    {
        $this->status = true;
    }
    
    
    public function disable(): void
    {
        $this->status = false;
    }
    
    
    /**
     * @param string $newColor
     */
    public function changeColor($newColor): void
    {
        $this->hexColorCode = $newColor;
    }
    
    
    /**
     * @param PopupContent $newContent
     */
    public function changeContent(PopupContent $newContent): void
    {
        $this->contents->update($newContent);
    }
    
    
    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            'status'   => $this->status,
            'color'    => $this->hexColorCode,
            'contents' => $this->contents->toArray()
        ];
    }
}