<?php
/* --------------------------------------------------------------
 OfflineStatusService.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\OfflineStatus;

/**
 * Interface OfflineStatusService
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Services
 */
interface OfflineStatusService
{
    /**
     * @return OfflineStatus
     */
    public function getOfflineStatus(): OfflineStatus;
    
    
    public function enableOfflineMode(): void;
    
    
    public function disableOfflineMode(): void;
    
    
    /**
     * @param string $newMessage
     */
    public function changeMessage(string $newMessage): void;
}