<?php
/* --------------------------------------------------------------
 ShopStatusRepository.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\Popup;
use GXModules\GambioSamples\ShopStatusManager\Model\OfflineStatus;
use GXModules\GambioSamples\ShopStatusManager\Model\Topbar;

/**
 * Interface ShopStatusRepository
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Services
 */
interface ShopStatusRepository
{
    /**
     * @return OfflineStatus
     */
    public function getOfflineStatus(): OfflineStatus;
    
    
    /**
     * @param OfflineStatus $shopStatus
     */
    public function saveOfflineStatus(OfflineStatus $shopStatus): void;
    
    
    /**
     * @return Popup
     */
    public function getPopup(): Popup;
    
    
    /**
     * @param Popup $popup
     *
     * @return mixed
     */
    public function savePopup(Popup $popup);
    
    
    /**
     * @return Topbar
     */
    public function getTopbar(): Topbar;
    
    
    /**
     * @param Topbar $topbar
     *
     * @return mixed
     */
    public function saveTopbar(TopBar $topbar);
}