<?php
/* --------------------------------------------------------------
 ShopStatusManagerServiceProvider.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\DependencyInjection\AbstractModuleServiceProvider;
use Gambio\Core\Configuration\Services\ConfigurationFinder;
use Gambio\Core\Configuration\Services\ConfigurationService;
use GXModules\GambioSamples\ShopStatusManager\App\Actions\SaveOfflineStatus;
use GXModules\GambioSamples\ShopStatusManager\App\Actions\SavePopup;
use GXModules\GambioSamples\ShopStatusManager\App\Actions\SaveTopbar;
use GXModules\GambioSamples\ShopStatusManager\App\Actions\ShopStatusOverview;
use GXModules\GambioSamples\ShopStatusManager\App\Data\ShopStatusMapper;
use GXModules\GambioSamples\ShopStatusManager\App\Data\ShopStatusReader;
use GXModules\GambioSamples\ShopStatusManager\App\Data\ShopStatusWriter;
use GXModules\GambioSamples\ShopStatusManager\Services\OfflineStatusService;
use GXModules\GambioSamples\ShopStatusManager\Services\PopupService;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusFactory;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusRepository;
use GXModules\GambioSamples\ShopStatusManager\Services\TopbarService;

/**
 * Class ShopStatusManagerServiceProvider
 *
 * @package GXModules\GambioSamples\ShopStatusManager
 */
class ShopStatusManagerServiceProvider extends AbstractModuleServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            ShopStatusOverview::class,
            SaveTopbar::class,
            SavePopup::class,
            SaveOfflineStatus::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(ShopStatusOverview::class)->addArguments([
                                                                                        TopbarService::class,
                                                                                        PopupService::class,
                                                                                        OfflineStatusService::class,
                                                                                    ]);
        $this->application->registerShared(SaveTopbar::class)->addArgument(TopbarService::class);
        $this->application->registerShared(SavePopup::class)->addArgument(PopupService::class);
        $this->application->registerShared(SaveOfflineStatus::class)->addArgument(OfflineStatusService::class);
        
        $this->registerServices();
        $this->registerRepository();
    }
    
    
    private function registerServices(): void
    {
        $this->application->registerShared(TopbarService::class, App\Services\TopbarService::class)->addArguments([
                                                                                                                      ShopStatusRepository::class,
                                                                                                                      ShopStatusFactory::class,
                                                                                                                  ]);
        $this->application->registerShared(PopupService::class, App\Services\PopupService::class)->addArguments([
                                                                                                                    ShopStatusRepository::class,
                                                                                                                    ShopStatusFactory::class,
                                                                                                                ]);
        $this->application->registerShared(OfflineStatusService::class, App\Services\OfflineStatusService::class)
            ->addArgument(ShopStatusRepository::class);
    }
    
    
    private function registerRepository(): void
    {
        $this->application->registerShared(ShopStatusRepository::class, App\Data\ShopStatusRepository::class)
            ->addArguments([
                               ShopStatusReader::class,
                               ShopStatusWriter::class,
                               ShopStatusMapper::class,
                           ]);
        $this->application->registerShared(ShopStatusFactory::class);
        $this->application->registerShared(ShopStatusReader::class)->addArguments([
                                                                                      Connection::class,
                                                                                      ConfigurationFinder::class,
                                                                                  ]);
        $this->application->registerShared(ShopStatusWriter::class)->addArguments([
                                                                                      Connection::class,
                                                                                      ConfigurationService::class,
                                                                                  ]);
        $this->application->registerShared(ShopStatusMapper::class)->addArgument(ShopStatusFactory::class);
    }
}