<?php
/* --------------------------------------------------------------
 TwigEngine.php 2020-09-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\TwigAdminEngine\Support\Engine;

use Exception;
use Gambio\Core\TemplateEngine\Exceptions\RenderingFailedException;
use Gambio\Core\TemplateEngine\TemplateEngine;
use Twig\Environment;

/**
 * Class TwigEngine
 *
 * @package GXModules\GambioSamples\TwigAdminEngine\Support\Engine
 */
class TwigEngine implements TemplateEngine
{
    /**
     * @var Environment
     */
    private $twig;
    
    
    /**
     * @param TwigEngineFactory $factory
     */
    public function __construct(TwigEngineFactory $factory)
    {
        $this->twig = $factory->create();
    }
    
    
    /**
     * @inheritDoc
     */
    public function render(string $templatePath, array $data = []): string
    {
        try {
            return $this->twig->render($templatePath, $data);
        } catch (Exception $e) {
            $message = "Failed to render template '{$templatePath}'.\n{$e->getMessage()}";
            throw new RenderingFailedException($message, 0, $e);
        }
    }
}