<?php
/* --------------------------------------------------------------
 TwigEngineFactory.php 2020-09-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\TwigAdminEngine\Support\Engine;

use Gambio\Core\GXModules\App\Data\ActiveGXModulePathsProvider;
use Twig\Environment;
use Twig\Loader\FilesystemLoader;

/**
 * Class TwigEngineFactory
 *
 * @package GXModules\GambioSamples\TwigAdminEngine\Support\Engine
 */
class TwigEngineFactory
{
    /**
     * @var ActiveGXModulePathsProvider
     */
    private $gxModulesPaths;
    
    
    /**
     * @param ActiveGXModulePathsProvider $gxModulesPaths
     */
    public function __construct(ActiveGXModulePathsProvider $gxModulesPaths)
    {
        $this->gxModulesPaths = $gxModulesPaths;
    }
    
    
    /**
     * @return Environment
     */
    public function create(): Environment
    {
        $pathRegistry = [];
        
        foreach ($this->gxModulesPaths->getActiveGXModulePaths() as $module) {
            $path  = "{$module}*/ui/";
            $paths = glob($path);
            if (!empty($paths)) {
                $pathRegistry[] = glob($path);
            }
        }
        $pathRegistry   = array_merge(...$pathRegistry);
        $pathRegistry[] = __DIR__ . '/../../ui/template';
        
        $loader = new FilesystemLoader($pathRegistry);
        
        return new Environment($loader, []);
    }
}