<?php
/* --------------------------------------------------------------
 CacheCleanerServiceProvider.php 2020-08-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\CacheCleaner;

use Gambio\Core\Application\DependencyInjection\AbstractModuleServiceProvider;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Cache\Services\CacheFactory;
use GXModules\GambioSamples\CacheCleaner\App\Actions\CacheCleanerOverview;
use GXModules\GambioSamples\CacheCleaner\App\Actions\ClearAllCaches;
use GXModules\GambioSamples\CacheCleaner\App\Actions\ClearCoreCache;
use GXModules\GambioSamples\CacheCleaner\Service\CacheCleanerService;

/**
 * Class CacheCleanerServiceProvider
 *
 * @package GXModules\GambioSamples\CacheCleaner
 */
class CacheCleanerServiceProvider extends AbstractModuleServiceProvider
{
    /**
     * @inheritcDoc
     */
    public function provides(): array
    {
        return [
            CacheCleanerOverview::class,
            ClearAllCaches::class,
            ClearCoreCache::class,
        ];
    }
    
    
    /**
     * @inheritcDoc
     */
    public function register(): void
    {
        $this->application->registerShared(CacheCleanerOverview::class);
        $this->application->registerShared(ClearAllCaches::class)->addArgument(CacheCleanerService::class);
        $this->application->registerShared(ClearCoreCache::class)->addArgument(CacheCleanerService::class);
        
        $this->application->registerShared(CacheCleanerService::class, App\CacheCleanerService::class)
            ->addArguments([CacheFactory::class, Path::class]);
    }
}