<?php
/* --------------------------------------------------------------
 CacheCleanerService.php 2020-08-27
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\CacheCleaner\Service;

/**
 * Interface CacheCleanerService
 *
 * @package GXModules\GambioSamples\CacheCleaner\Service
 */
interface CacheCleanerService
{
    /**
     * Clears all of the cache data.
     */
    public function clearAll(): void;
    
    
    /**
     * Clears the core cache files.
     *
     * The core cache files contains information like service providers and registered external modules.
     */
    public function clearCore(): void;
}
