<?php
/* --------------------------------------------------------------
 routes.php 2021-05-14
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

use Gambio\Core\Application\Routing\RouteCollector;
use GXModules\GambioSamples\CacheCleaner\App\Actions\CacheCleanerOverview;
use GXModules\GambioSamples\CacheCleaner\App\Actions\ClearAllCaches;
use GXModules\GambioSamples\CacheCleaner\App\Actions\ClearCoreCache;

return static function (RouteCollector $routeCollector) {
    $routeCollector->get('/admin/gambio-samples/cache-cleaner', CacheCleanerOverview::class);
    
    $routeCollector->post('/admin/gambio-samples/cache-cleaner/clear-all', ClearAllCaches::class);
    $routeCollector->post('/admin/gambio-samples/cache-cleaner/clear-core', ClearCoreCache::class);
};
