<?php
/* --------------------------------------------------------------
 HelloWorldServiceProvider.php 2020-08-28
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\HelloWorld;

use Gambio\Core\Application\DependencyInjection\AbstractModuleServiceProvider;

/**
 * Class HelloWorldServiceProvider
 *
 * The service provider is a modules backbone.
 *
 * The responsibility of a service provider is to register all of the modules components to the application.
 * This is done by using the $application properties inside of the ::register() method.
 *
 * Route callbacks, like action classes must be defined in the ::provides() method. This is required,
 * because the application will inject additional components for action classes that extend from the
 * Gambio\Admin\Application\Http\AdminModuleAction class.
 *
 * If you want to make some further functionality available in the system, like for other external modules,
 * you also have to define them in the ::provides() method, so the DI container can provide them on demand.
 *
 * @package GXModules\GambioSamples\HelloWorld
 */
class HelloWorldServiceProvider extends AbstractModuleServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            HelloWorldAction::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(HelloWorldAction::class);
    }
}