<?php
/* --------------------------------------------------------------
 SaveShopStatus.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Actions;

use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;
use GXModules\GambioSamples\ShopStatusManager\Services\OfflineStatusService;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAction;

/**
 * Class SaveOfflineStatus
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Actions
 */
class SaveOfflineStatus extends TwigAction
{
    /**
     * @var OfflineStatusService
     */
    private $service;
    
    
    /**
     * @param OfflineStatusService $service
     */
    public function __construct(OfflineStatusService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $requestData = $request->getParsedBody();
        
        array_key_exists('status',
                         $requestData) ? $this->service->disableOfflineMode() : $this->service->enableOfflineMode();
        
        $this->service->changeMessage($requestData['message'] ?? '');
        
        $redirectUrl = "{$this->url->admin()}/gambio-samples/shop-status";
        
        return $response->withHeader('Location', $redirectUrl);
    }
}