<?php
/* --------------------------------------------------------------
 SavePopup.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Actions;

use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;
use GXModules\GambioSamples\ShopStatusManager\Services\PopupService;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAction;

/**
 * Class SavePopup
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Actions
 */
class SavePopup extends TwigAction
{
    /**
     * @var PopupService
     */
    private $popupService;
    
    
    /**
     * @param PopupService $popupService
     */
    public function __construct(PopupService $popupService)
    {
        $this->popupService = $popupService;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $requestData = $request->getParsedBody();
        
        array_key_exists('status', $requestData) ? $this->popupService->enablePopup(
        ) : $this->popupService->disablePopup();
        
        foreach ($requestData['contents'] as $languageCode => $content) {
            $this->popupService->changePopupContent($content, $languageCode);
        }
        
        $redirectUrl = "{$this->url->admin()}/gambio-samples/shop-status";
    
        return $response->withHeader('Location', $redirectUrl);
    }
}