<?php
/* --------------------------------------------------------------
 SaveTopbar.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Actions;

use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;
use GXModules\GambioSamples\ShopStatusManager\Services\TopbarService;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAction;

/**
 * Class SaveTopbar
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Actions
 */
class SaveTopbar extends TwigAction
{
    /**
     * @var TopbarService
     */
    private $topbarService;
    
    
    /**
     * @param TopbarService $topbarService
     */
    public function __construct(TopbarService $topbarService)
    {
        $this->topbarService = $topbarService;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $requestData = $request->getParsedBody();
        
        array_key_exists('status', $requestData) ? $this->topbarService->enableTopBar(
        ) : $this->topbarService->disableTopBar();
        
        $this->topbarService->changeTopBarColor($requestData['color']);
        
        foreach ($requestData['contents'] as $languageCode => $content) {
            $this->topbarService->changeTopBarContent($content, $languageCode);
        }
        
        $redirectUrl = "{$this->url->admin()}/gambio-samples/shop-status";
    
        return $response->withHeader('Location', $redirectUrl);
    }
}