<?php
/* --------------------------------------------------------------
 ShopStatusRepository.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Data;

use Doctrine\DBAL\DBALException;
use GXModules\GambioSamples\ShopStatusManager\Model\Popup;
use GXModules\GambioSamples\ShopStatusManager\Model\OfflineStatus;
use GXModules\GambioSamples\ShopStatusManager\Model\Topbar;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusRepository as ShopStatusInterface;

/**
 * Class ShopStatusRepository
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Data
 */
class ShopStatusRepository implements ShopStatusInterface
{
    /**
     * @var ShopStatusReader
     */
    private $reader;
    
    /**
     * @var ShopStatusWriter
     */
    private $writer;
    
    /**
     * @var ShopStatusMapper
     */
    private $mapper;
    
    
    /**
     * @param ShopStatusReader $reader
     * @param ShopStatusWriter $writer
     * @param ShopStatusMapper $mapper
     */
    public function __construct(ShopStatusReader $reader, ShopStatusWriter $writer, ShopStatusMapper $mapper)
    {
        $this->reader = $reader;
        $this->writer = $writer;
        $this->mapper = $mapper;
    }
    
    
    /**
     * @return OfflineStatus
     */
    public function getOfflineStatus(): OfflineStatus
    {
        $data = $this->reader->getStatusData();
        
        return $this->mapper->mapStatus($data);
    }
    
    
    /**
     * @param OfflineStatus $shopStatus
     */
    public function saveOfflineStatus(OfflineStatus $shopStatus): void
    {
        $this->writer->saveStatus($shopStatus);
    }
    
    
    /**
     * @return Popup
     */
    public function getPopup(): Popup
    {
        $data = $this->reader->getPopupData();
        
        return $this->mapper->mapPopup($data);
    }
    
    
    /**
     * @param Popup $popup
     *
     * @throws DBALException
     */
    public function savePopup(Popup $popup): void
    {
        $this->writer->savePopup($popup);
    }
    
    
    /**
     * @return Topbar
     */
    public function getTopbar(): Topbar
    {
        $data = $this->reader->getTopBarData();
        
        return $this->mapper->mapTopbar($data);
    }
    
    
    /**
     * @param Topbar $topbar
     *
     * @throws DBALException
     */
    public function saveTopbar(TopBar $topbar): void
    {
        $this->writer->saveTopbar($topbar);
    }
}