<?php
/* --------------------------------------------------------------
 OfflineStatusService.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\App\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\OfflineStatus;
use GXModules\GambioSamples\ShopStatusManager\Services\ShopStatusRepository;
use GXModules\GambioSamples\ShopStatusManager\Services\OfflineStatusService as Service;

/**
 * Class OfflineStatusService
 *
 * @package GXModules\GambioSamples\ShopStatusManager\App\Services
 */
class OfflineStatusService implements Service
{
    /**
     * @var ShopStatusRepository
     */
    private $repository;
    
    
    /**
     * @param ShopStatusRepository $repository
     */
    public function __construct(ShopStatusRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @return OfflineStatus
     */
    public function getOfflineStatus(): OfflineStatus
    {
        return $this->repository->getOfflineStatus();
    }
    
    
    public function enableOfflineMode(): void
    {
        $status = $this->repository->getOfflineStatus();
        $status->enableOfflineMode();
        
        $this->repository->saveOfflineStatus($status);
    }
    
    
    public function disableOfflineMode(): void
    {
        $status = $this->repository->getOfflineStatus();
        $status->disableOfflineMode();
        
        $this->repository->saveOfflineStatus($status);
    }
    
    
    /**
     * @param string $newMessage
     */
    public function changeMessage(string $newMessage): void
    {
        $status = $this->repository->getOfflineStatus();
        $status->changeMessage($newMessage);
        
        $this->repository->saveOfflineStatus($status);
    }
}