<?php
/* --------------------------------------------------------------
 PopupContents.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Model\Collections;

use GXModules\GambioSamples\ShopStatusManager\Model\PopupContent;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContents as Contents;

/**
 * Class PopupContents
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Model\Collections
 */
class PopupContents implements Contents
{
    /**
     * @var PopupContent[]
     */
    private $contents;
    
    
    /**
     * @param PopupContent ...$contents
     */
    public function __construct(PopupContent ...$contents)
    {
        $this->contents = $contents;
    }
    
    
    /**
     * @param PopupContent $newContent
     */
    public function update(PopupContent $newContent): void
    {
        foreach ($this->contents as $key => $content) {
            if ($content->hasSameLanguage($newContent)) {
                $this->contents[$key] = $newContent;
                
                return;
            }
        }
        $this->contents[] = $newContent;
    }
    
    
    /**
     * @return array
     */
    public function toArray(): array
    {
        $data = [];
        foreach ($this->contents as $content) {
            $data[] = $content->toArray();
        }
        
        return $data;
    }
}