<?php
/* --------------------------------------------------------------
 Popup.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects;

use GXModules\GambioSamples\ShopStatusManager\Model\Popup as PopupApi;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContent;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContents;

/**
 * Class Popup
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects
 */
class Popup implements PopupApi
{
    /**
     * @var bool
     */
    private $status;
    
    /**
     * @var PopupContents
     */
    private $contents;
    
    
    /**
     * @param bool          $status
     * @param PopupContents $contents
     */
    public function __construct(bool $status, PopupContents $contents)
    {
        $this->status   = $status;
        $this->contents = $contents;
    }
    
    
    public function enable(): void
    {
        $this->status = true;
    }
    
    
    public function disable(): void
    {
        $this->status = false;
    }
    
    
    /**
     * @param PopupContent $newContent
     */
    public function changeContent(PopupContent $newContent): void
    {
        $this->contents->update($newContent);
    }
    
    
    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            'status'   => $this->status,
            'contents' => $this->contents->toArray()
        ];
    }
}