<?php
/* --------------------------------------------------------------
 PopupContent.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects;

use GXModules\GambioSamples\ShopStatusManager\Model\PopupContent as Content;

/**
 * Class PopupContent
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects
 */
class PopupContent implements Content
{
    /**
     * @var string
     */
    private $content;
    
    /**
     * @var string
     */
    private $languageCode;
    
    
    /**
     * @param string $content
     * @param string $languageCode
     */
    public function __construct(string $content, string $languageCode)
    {
        $this->content      = $content;
        $this->languageCode = $languageCode;
    }
    
    
    /**
     * @param Content $other
     *
     * @return bool
     */
    public function hasSameLanguage(Content $other): bool
    {
        return $this->languageCode === $other->languageCode;
    }
    
    
    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            'content'      => $this->content,
            'languageCode' => $this->languageCode
        ];
    }
}