<?php
/* --------------------------------------------------------------
 PopupService.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\Popup;

/**
 * Interface PopupService
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Services
 */
interface PopupService
{
    /**
     * @return Popup
     */
    public function getPopup(): Popup;
    
    
    public function enablePopup(): void;
    
    
    public function disablePopup(): void;
    
    
    /**
     * @param string $newContent
     * @param string $languageCode
     */
    public function changePopupContent(string $newContent, string $languageCode): void;
}