<?php
/* --------------------------------------------------------------
 ShopStatusFactory.php 2020-09-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\Collections\PopupContents;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContent as Content;
use GXModules\GambioSamples\ShopStatusManager\Model\PopupContents as Contents;
use GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects\Popup;
use GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects\PopupContent;
use GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects\OfflineStatus;
use GXModules\GambioSamples\ShopStatusManager\Model\ValueObjects\TopBar;

/**
 * Class ShopStatusFactory
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Services
 */
class ShopStatusFactory
{
    /**
     * @param bool     $status
     * @param string   $hexColorCode
     * @param Contents $contents
     *
     * @return TopBar
     */
    public function createTopbar(bool $status, string $hexColorCode, Contents $contents): TopBar
    {
        return new TopBar($status, $hexColorCode, $contents);
    }
    
    
    /**
     * @param Content ...$contents
     *
     * @return PopupContents
     */
    public function createPopupContents(Content ...$contents): PopupContents
    {
        return new PopupContents(...$contents);
    }
    
    
    /**
     * @param string $content
     * @param string $languageCode
     *
     * @return PopupContent
     */
    public function createPopupContent(string $content, string $languageCode): PopupContent
    {
        return new PopupContent($content, $languageCode);
    }
    
    
    /**
     * @param bool     $status
     * @param Contents $contents
     *
     * @return Popup
     */
    public function createPopup(bool $status, Contents $contents): Popup
    {
        return new Popup($status, $contents);
    }
    
    
    /**
     * @param bool   $status
     * @param string $message
     *
     * @return OfflineStatus
     */
    public function createShopStatus(bool $status, string $message): OfflineStatus
    {
        return new OfflineStatus($status, $message);
    }
}