<?php
/* --------------------------------------------------------------
 TopBarService.php 2020-09-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\ShopStatusManager\Services;

use GXModules\GambioSamples\ShopStatusManager\Model\Topbar;

/**
 * Interface TopbarService
 *
 * @package GXModules\GambioSamples\ShopStatusManager\Services
 */
interface TopbarService
{
    /**
     * @return Topbar
     */
    public function getTopBar(): Topbar;
    
    
    public function enableTopBar(): void;
    
    
    public function disableTopBar(): void;
    
    
    /**
     * @param string $hexColorCode
     */
    public function changeTopBarColor(string $hexColorCode): void;
    
    
    /**
     * @param string $newContent
     * @param string $languageCode
     */
    public function changeTopBarContent(string $newContent, string $languageCode): void;
}