<?php
/* --------------------------------------------------------------
 TwigAdminEngineServiceProvider.php 2020-09-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\TwigAdminEngine;

use Gambio\Admin\Layout\Renderer\GambioAdminLoader;
use Gambio\Core\Application\DependencyInjection\AbstractModuleBootableServiceProvider;
use Gambio\Core\GXModules\App\Data\ActiveGXModulePathsProvider;
use Gambio\Core\TemplateEngine\LayoutData;
use GXModules\GambioSamples\TwigAdminEngine\Support\Engine\TwigEngine;
use GXModules\GambioSamples\TwigAdminEngine\Support\Engine\TwigEngineFactory;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAction;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAdminRenderer;

/**
 * Class TwigAdminEngineServiceProvider
 *
 * @package GXModules\GambioSamples\TwigAdminEngine
 */
class TwigAdminEngineServiceProvider extends AbstractModuleBootableServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            TwigAdminRenderer::class,
            TwigEngine::class,
            TwigAction::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(TwigAdminRenderer::class)->addArguments(
            [
                TwigEngine::class,
                GambioAdminLoader::class,
                LayoutData::class
            ]
        );
        $this->application->registerShared(TwigEngine::class)->addArgument(TwigEngineFactory::class);
        $this->application->registerShared(TwigEngineFactory::class)->addArgument(ActiveGXModulePathsProvider::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        require_once __DIR__ . '/vendor/autoload.php';
        
        $this->application->inflect(TwigAction::class)->invokeMethod('replaceRenderer', [TwigAdminRenderer::class]);
    }
}