<?php
/* --------------------------------------------------------------
 TwigModuleTestAction.php 2020-09-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\TwigModule\App\Action;

use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;
use Gambio\Core\TemplateEngine\Exceptions\RenderingFailedException;
use GXModules\GambioSamples\TwigAdminEngine\Support\TwigAction;

/**
 * Class TwigModuleTestAction
 *
 * @package GXModules\GambioSamples\TwigModule\App\Action
 */
class TwigModuleTestAction extends TwigAction
{
    /**
     * @param Request  $request
     * @param Response $response
     *
     * @return Response
     * @throws RenderingFailedException
     */
    public function handle(Request $request, Response $response): Response
    {
        $data     = [
            'hello' => 'world',
            'list'  => [
                'hello-world' => [
                    'hello',
                    'world'
                ],
                'foo'         => [
                    'bar',
                    'baz'
                ]
            ]
        ];
        $template = $this->render('Twig Page', 'twig_module/overview.twig', $data);
        
        return $response->write($template);
    }
}