<?php
/* --------------------------------------------------------------
 TwigModuleServiceProvider.php 2020-09-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace GXModules\GambioSamples\TwigModule;

use Gambio\Core\Application\DependencyInjection\AbstractModuleServiceProvider;
use GXModules\GambioSamples\TwigModule\App\Action\TwigModuleTestAction;

/**
 * Class TwigModuleServiceProvider
 *
 * @package GXModules\GambioSamples\TwigModule
 */
class TwigModuleServiceProvider extends AbstractModuleServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            TwigModuleTestAction::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(TwigModuleTestAction::class);
    }
}